//+------------------------------------------------------------------+
//|                                                        |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2005, FX Sniper "
#property  link      "http://www.metaquotes.net/"

//---- indicator settings
#property  indicator_chart_window

#property  indicator_buffers 3
#property indicator_color1 Yellow      
#property indicator_color2 Green
#property indicator_color3 Red

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];

extern int Rperiod = 48;
extern int Draw4HowLong = 500;

//----- variables
int    c;
int    i;
int    length;
double lengthvar;
int    loopbegin;
int    pos;
int    width;


// arrays 
double sum[];
double tmp ;
double wt[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   //2 additional buffers are used for counting.
   IndicatorBuffers(5);

   SetIndexBuffer(2,ExtMapBuffer1);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexBuffer(0,ExtMapBuffer3);
   SetIndexBuffer(3,sum);
   SetIndexBuffer(4,wt);
    
   SetIndexStyle(2, DRAW_LINE, STYLE_SOLID, 2);
   SetIndexStyle(1, DRAW_LINE, STYLE_SOLID, 2);
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 2);

   return(0);
  }

int start()

  {   
      length = Rperiod;
      loopbegin = Draw4HowLong - length - 1;
 
      for(pos = loopbegin; pos >= 0; pos--)
      { 
         sum[1] = 0;
         for(i = length; i >= 1  ; i--)
         {
         lengthvar = length + 1;
         lengthvar /= 3;
         tmp = 0;
         tmp = ( i - lengthvar)*Close[length-i+pos];
         sum[1]+=tmp;
         }
         
         wt[pos] = sum[1]*6/(length*(length+1));
         
//========== COLOR CODING ===========================================               
        
      // 1 Yellow      
      // 2 Green
      // 3 Red

       ExtMapBuffer3[pos] = wt[pos]; //red 
       ExtMapBuffer2[pos] = wt[pos]; //green
       ExtMapBuffer1[pos] = wt[pos]; //yellow
       
        if (wt[pos+1] > wt[pos])
        {
        ExtMapBuffer2[pos+1] = EMPTY_VALUE;
        }
       else if (wt[pos+1] < wt[pos]) 
        {
        ExtMapBuffer1[pos+1] = EMPTY_VALUE; //-1 red/greem tight
        }
         else 
         {
         ExtMapBuffer1[pos+1]=CLR_NONE;//EMPTY_VALUE;
         ExtMapBuffer2[pos+1]=CLR_NONE;//EMPTY_VALUE;
         }
        
      }
    
      return(0);
  }
//+------------------------------------------------------------------+



